<?php
//Used PHPFlexer to do a precompile in the actual code release.
ini_set("display_errors",1);
error_reporting(E_ALL);
date_default_timezone_set("UTC"); 
function XMLParser($XML,$tag) {
    $sp=stripos($XML,"<".$tag.">")+2+strlen($tag);
    $ep=strripos($XML,"</".$tag.">");
    return substr($XML,$sp,$ep-$sp);
};
function DOFilter($DO) {
    if($DO=="Light On/Off") {
        $DO=1;
    } elseif($DO=="Event On/Off") {
        $DO=4;
    } elseif($DO=="Light Dimming") {
        $DO=2;
    } else {
        $DO=0;
    };
    return $DO;
};
function AIFilter($AI) {
    if($AI=="mV") {
        $AI=2;
    } elseif($AI=="Volts") {
        $AI=3;
    } elseif($AI=="mA") {
        $AI=4;
    } elseif($AI=="RTD") {
        $AI=5;
    } else {
        $AI=0;
    };
    return $AI;
};
function programFilter($UI) {
    if(strpos($UI,'Step') !== false) {
        $UI=explode($UI,",");
        $program[0]="PROG";
        $program[1]=$UI[0];
        $UI=explode($UI,": ");
        $program[2]=$UI[1];
    } elseif(strpos($UI,'Diurnal')!==false) {
        $program[0]="DIUR";
        $program[1]='NA      ';
        $program[2]="0";
    } else {
        $program[0]="MAN ";
        $program[1]='NA      ';
        $program[2]="0";
    };
    return $program;
};
function enableFilter($CLC) {
    if($CLC=="Yes") {
        $CLC='YES ';
    }elseif($CLC=="No") {
        $CLC="NO";
    }else {
        $CLC='NO  ';
    };
    return $CLC;
};
function configurationMessage($ip) {
    //Create configuration message.
    $tagFieldNames="Year,Month,Day,Hour,Minute,Second,Mode,Prog_Name,Prog_Step,Seq_Step,Seq_Iter,PV_1,SP_1,PV_2,SP_2,PV_3,SP_3,PV_4,SP_4,PV_5,SP_5,PV_6,SP_6,PV_7,SP_7,EO_1,EO_2,EO_3,EO_4,EO_5,EO_6,EO_7,EO_8,EO_9,EO_10,EO_11,EO_12,EO_13,EO_14,EO_15,EO_16,EO_17,EO_18,EO_19,EO_20,EO_21,EO_22,EO_23,EO_24,EO_25,EO_26,EO_27,EO_28,EO_29,EO_30,EO_31,EO_32,EO_33,EO_34,EO_35,EO_36,EO_37,EO_38,EO_39,EO_40,EO_41,EO_42,EO_43,EO_44,EO_45,EO_46,EO_47,Lim_2_PV,Defrost,DLI,DLI_Acc,Lim_1_Hi,Lim_1_Lo,Lim_2_Hi,Lim_2_Lo,Alm_1_Hi,Alm_1_Lo,Dev_Hi,Dev_Lo,Alm_2_Hi,Alm_2_Lo,Alm_3_Hi,Alm_3_Lo,Alm_4_Hi,Alm_4_Lo,Alm_5_Hi,Alm_5_Lo,Alm_6_Hi,Alm_6_Lo,Alm_7_Hi,Alm_7_Lo,Light_Life,Lim_1_Alarm,Lim_2_Alarm,Dev_Alarm,Alm_1_Alarm,Alm_2_Alarm,Alm_3_Alarm,Alm_4_Alarm,Alm_5_Alarm,Alm_6_Alarm,Alm_7_Alarm,Life_Alarm,Ch2A_Ena,Ch2B_Ena,Ch3A_Ena,Ch3B_Ena,Ch4A_Ena,Ch4B_Ena,Ch5A_Ena,Ch5B_Ena,Ch6A_Ena,Ch6B_Ena,Ch7A_Ena,Ch7B_Ena,Light1_Life,Light2_Life,Light3_Life,Light4_Life,Light5_Life,Light6_Life,Light7_Life,Light8_Life,Light9_Life,Light10_Life,Light11_Life,Light12_Life,Light13_Life,Light14_Life,Light15_Life,Light16_Life,Light17_Life,Light18_Life,Light19_Life,Light20_Life,Light21_Life,Light22_Life,Light23_Life,Light24_Life,Light25_Life,Light26_Life,Light27_Life,Light28_Life,Light29_Life,Light30_Life,Light31_Life,Light32_Life,Light33_Life,Light34_Life,Light35_Life,Light36_Life,Light37_Life,Light38_Life,Light39_Life,Light40_Life,Light41_Life,Light42_Life,Light43_Life,Light44_Life,Light45_Life,Light46_Life,Light47_Life\n";
    $preGrabDOs=file_get_contents("http://{$ip}/read_data.xml?Cmd=read&Tag=DO_Function_1&Tag=DO_Function_2&Tag=DO_Function_3&Tag=DO_Function_4&Tag=DO_Function_5&Tag=DO_Function_6&Tag=DO_Function_7&Tag=DO_Function_8&Tag=DO_Function_9&Tag=DO_Function_10&Tag=DO_Function_11&Tag=DO_Function_12&Tag=DO_Function_13&Tag=DO_Function_14&Tag=DO_Function_15&Tag=DO_Function_16&Tag=AI_Sensor_2&Tag=AI_Sensor_3");
    //$test=XMLParser($pregrabDOs,"DO_Function_2");
    //echo "<BR>".$test."<BR>";
    //$grabDOs=new SimpleXMLElement($pregrabDOs);
    $DO1=DOFilter(XMLParser($preGrabDOs,"DO_Function_1"));
    $DO2=DOFilter(XMLParser($preGrabDOs,"DO_Function_2"));
    $DO3=DOFilter(XMLParser($preGrabDOs,"DO_Function_3"));
    $DO4=DOFilter(XMLParser($preGrabDOs,"DO_Function_4"));
    $DO5=DOFilter(XMLParser($preGrabDOs,"DO_Function_5"));
    $DO6=DOFilter(XMLParser($preGrabDOs,"DO_Function_6"));
    $DO7=DOFilter(XMLParser($preGrabDOs,"DO_Function_7"));
    $DO8=DOFilter(XMLParser($preGrabDOs,"DO_Function_8"));
    $DO9=DOFilter(XMLParser($preGrabDOs,"DO_Function_9"));
    $DO10=DOFilter(XMLParser($preGrabDOs,"DO_Function_10"));
    $DO11=DOFilter(XMLParser($preGrabDOs,"DO_Function_11"));
    $DO12=DOFilter(XMLParser($preGrabDOs,"DO_Function_12"));
    $DO13=DOFilter(XMLParser($preGrabDOs,"DO_Function_13"));
    $DO14=DOFilter(XMLParser($preGrabDOs,"DO_Function_14"));
    $DO15=DOFilter(XMLParser($preGrabDOs,"DO_Function_15"));
    $DO16=DOFilter(XMLParser($preGrabDOs,"DO_Function_16"));
    $AI2=AIFilter(XMLParser($preGrabDOs,"AI_Sensor_2"));
    $AI3=AIFilter(XMLParser($preGrabDOs,"AI_Sensor_3"));
    $digitalOutputTypes=$DO1.",".$DO2.",".$DO3.",".$DO4.",".$DO5.",".$DO6.",".$DO7.",".$DO8.",".$DO9.",".$DO10.",".$DO11.",".$DO12.",".$DO13.",".$DO14.",".$DO15.",".$DO16.",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n";
    $processInputTypes="5".",".$AI2.",".$AI3.",0,0,0,0\n";
    $rmTypes="1,1,1,1\n";
    $inputNames="Temp,RH  ,Aux ,LS1 ,LS2 ,LS3 ,LS4 \n";
    $inputUnits="C  ,%RH,PPM,UML,UML,UML,UML\n";
    $alarms="1,1,1,1,1,0,0,0,0,0,0";
    $configMessage=$tagFieldNames.$digitalOutputTypes.$processInputTypes.$rmTypes.$inputNames.$inputUnits.$alarms;
    return $configMessage;
};
function standardData($ip) {
    //Create standard data interval
    $time=localtime();
    $second=$time[0];
    $minute=$time[1];
    $hour=$time[2]+1;
    $day=$time[3];
    $month=$time[4]+1;
    $year=$time[5]+1900;
    $preGrabDatapoint=file_get_contents("http://{$ip}/read_data.xml?Cmd=read&Tag=UI_Current_Info&Tag=PV_1&Tag=CM_SP_1_Manual&Tag=PV_2&Tag=CM_SP_2_Manual&Tag=PV_3&Tag=CM_SP_3_Manual");
    //$grabDatapoint=new SimpleXMLElement(file_get_contents("http://{$ip}/read_data.xml?Cmd=read&Tag=UI_Current_Info&Tag=PV_1&Tag=CM_SP_1_Manual&Tag=PV_2&Tag=CM_SP_2_Manual&Tag=PV_3&Tag=CM_SP_3_Manual&Tag=EO_1_Dim&Tag=EO_2_Dim&Tag=EO_3_Dim&Tag=EO_4_Dim&Tag=EO_5_Dim&Tag=EO_6_Dim&Tag=EO_7_Dim&Tag=EO_8_Dim&Tag=EO_9_Dim&Tag=EO_10_Dim&Tag=EO_11_Dim&Tag=EO_12_Dim&Tag=EO_13_Dim&Tag=EO_14_Dim&Tag=EO_15_Dim&Tag=EO_16_Dim&Tag=ALM_Temp_Safety_Alarm_Low&Tag=ALM_Temp_Safety_Alarm_High&Tag=ALM_Temp_Soft_Alarm_Low&Tag=ALM_Temp_Soft_Alarm_High&Tag=ALM_Rh_Soft_Alarm_Low&Tag=ALM_Rh_Soft_Alarm_High&Tag=ALM_Aux_Soft_Alarm_Low&Tag=ALM_Aux_Soft_Alarm_High&Tag=ALM_Deviation_Alarm_High&Tag=ALM_Deviation_Alarm_Low&Tag=CLC_Enable_Rh_1&Tag=CLC_Enable_Rh_2&Tag=CLC_Enable_Aux_1&Tag=CLC_Enable_Aux_2"));
    $program=programFilter(XMLParser($preGrabDatapoint,"UI_Current_Info"));
    $PV_1=(float) floatval(XMLParser($preGrabDatapoint,"PV_1"));
    $PV_2=(float) floatval(XMLParser($preGrabDatapoint,"PV_2"));
    $PV_3=(float) floatval(XMLParser($preGrabDatapoint,"PV_3"));
    $CM_SP_1_Manual=(float) floatval(XMLParser($preGrabDatapoint,"CM_SP_1_Manual"));
    $CM_SP_2_Manual=(float) floatval(XMLParser($preGrabDatapoint,"CM_SP_2_Manual"));
    $CM_SP_3_Manual=(float) floatval(XMLParser($preGrabDatapoint,"CM_SP_3_Manual"));
    $preGrabDatapoint=file_get_contents("http://{$ip}/read_data.xml?Cmd=read&Tag=EO_1_Dim&Tag=EO_2_Dim&Tag=EO_3_Dim&Tag=EO_4_Dim&Tag=EO_5_Dim&Tag=EO_6_Dim&Tag=EO_7_Dim&Tag=EO_8_Dim&Tag=EO_9_Dim&Tag=EO_10_Dim&Tag=EO_11_Dim&Tag=EO_12_Dim&Tag=EO_13_Dim&Tag=EO_14_Dim&Tag=EO_15_Dim&Tag=EO_16_Dim");
    $EO_1_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_1_Dim"));
    $EO_2_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_2_Dim"));
    $EO_3_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_3_Dim"));
    $EO_4_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_4_Dim"));
    $EO_5_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_5_Dim"));
    $EO_6_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_6_Dim"));
    $EO_7_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_7_Dim"));
    $EO_8_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_8_Dim"));
    $EO_9_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_9_Dim"));
    $EO_10_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_10_Dim"));
    $EO_11_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_11_Dim"));
    $EO_12_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_12_Dim"));
    $EO_13_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_13_Dim"));
    $EO_14_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_14_Dim"));
    $EO_15_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_15_Dim"));
    $EO_16_Dim=(float) floatval(XMLParser($preGrabDatapoint,"EO_16_Dim"));
    $preGrabDatapoint=file_get_contents("http://{$ip}/read_data.xml?Cmd=read&Tag=ALM_Temp_Safety_Alarm_Low&Tag=ALM_Temp_Safety_Alarm_High&Tag=ALM_Temp_Soft_Alarm_Low&Tag=ALM_Temp_Soft_Alarm_High&Tag=ALM_Rh_Soft_Alarm_Low&Tag=ALM_Rh_Soft_Alarm_High&Tag=ALM_Aux_Soft_Alarm_Low&Tag=ALM_Aux_Soft_Alarm_High&Tag=ALM_Deviation_Alarm_High&Tag=ALM_Deviation_Alarm_Low&Tag=CLC_Enable_Rh_1&Tag=CLC_Enable_Rh_2&Tag=CLC_Enable_Aux_1&Tag=CLC_Enable_Aux_2");
    /*
    $Rh1=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Rh_1"));
    $Rh2=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Rh_2"));
    $Aux1=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Aux_1"));
    $Aux2=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Aux_2"));
     */
    $Lim_1_Hi=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Temp_Safety_Alarm_High"));
    $Lim_1_Lo=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Temp_Safety_Alarm_Low"));
    $Alm_1_Hi=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Temp_Soft_Alarm_High"));
    $Alm_1_Lo=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Temp_Soft_Alarm_Low"));
    $Alm_2_Hi=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Rh_Soft_Alarm_High"));
    $Alm_2_Lo=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Rh_Soft_Alarm_Low"));
    $Alm_3_Hi=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Aux_Soft_Alarm_High"));
    $Alm_3_Lo=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Aux_Soft_Alarm_Low"));
    $Dev_Hi=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Deviation_Alarm_High"));
    $Dev_Lo=(float) floatval(XMLParser($preGrabDatapoint,"ALM_Deviation_Alarm_Low"));
    $Rh1=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Rh_1"));
    $Rh2=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Rh_2"));
    $Aux1=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Aux_1"));
    $Aux2=enableFilter(XMLParser($preGrabDatapoint,"CLC_Enable_Aux_2"));
    $Lim_1_Alarm="OFF ";
    if(($Rh1=="YES ")||($Rh2=="YES ")){
        if(($PV_1>$Alm_1_Hi)&&($Lim_1_Alarm=="OFF ")) { $Lim_1_Alarm="ON  ";} else{$Lim_1_Alarm="OFF ";};
        if(($PV_1<$Alm_1_Lo)&&($Lim_1_Alarm=="OFF ")) { $Lim_1_Alarm="ON  ";} else{$Lim_1_Alarm="OFF ";};
    };
    $Lim_2_Alarm="OFF ";
    if(($Rh1=="YES ")||($Rh2=="YES ")){
        if(($PV_2>$Alm_2_Hi)&&($Lim_2_Alarm=="OFF ")) { $Lim_2_Alarm="ON  ";} else{$Lim_2_Alarm="OFF ";};
        if(($PV_2<$Alm_2_Lo)&&($Lim_2_Alarm=="OFF ")) { $Lim_2_Alarm="ON  ";} else{$Lim_2_Alarm="OFF ";};
    };
    $Lim_3_Alarm="OFF ";
    if(($Aux1=="YES ")||($Aux2=="YES ")){
        if(($PV_3>$Alm_3_Hi)&&($Lim_3_Alarm=="OFF ")) { $Lim_3_Alarm="ON  ";} else{$Lim_3_Alarm="OFF ";};
        if(($PV_3<$Alm_3_Lo)&&($Lim_3_Alarm=="OFF ")) { $Lim_3_Alarm="ON  ";} else{$Lim_3_Alarm="OFF ";};
    };
    $standardMessage="{$year}".",".$month.",".$day.",".$hour.",".$minute.",".$second.",".$program[0].",".$program[1].",".$program[2].","."0,0,".$PV_1.",".$CM_SP_1_Manual.",".$PV_2.",".$CM_SP_2_Manual.",".$PV_3.",".$CM_SP_3_Manual.",0,0,0,0,0,0,0,0,".$EO_1_Dim.",".$EO_2_Dim.",".$EO_3_Dim.",".$EO_4_Dim.",".$EO_5_Dim.",".$EO_6_Dim.",".$EO_7_Dim.",".$EO_8_Dim.",".$EO_9_Dim.",".$EO_10_Dim.",".$EO_11_Dim.",".$EO_12_Dim.",".$EO_13_Dim.",".$EO_14_Dim.",".$EO_15_Dim.",".$EO_16_Dim.",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,".$PV_1.",NO,0,0,".$Lim_1_Hi.",".$Lim_1_Lo.",".$Lim_1_Hi.",".$Lim_1_Lo.",".$Alm_1_Hi.",".$Alm_1_Lo.",".$Dev_Hi.",".$Dev_Lo.",0,0,0,0,0,0,0,0,0,0,0,0,15000,".$Lim_1_Alarm.",".$Lim_1_Alarm.",OFF ,".$Lim_1_Alarm.",".$Lim_2_Alarm.",".$Lim_3_Alarm.',OFF ,OFF ,OFF ,OFF ,OFF ,'.$Rh1.",".$Rh2.",".$Aux1.",".$Aux2.',NO  ,NO  ,NO  ,NO  ,NO  ,NO  ,NO  ,NO  ,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0';
    return $standardMessage;
};


$fname="debugger.txt";
$nfile = fopen($fname, "w");
if($nfile != false) { 
	fwrite($nfile,"Background process started");
	fclose($nfile);
};


$ipChamber="192.168.1.1";
/*
$customer= $inputs[1];
$serial= $inputs[2];
$ip= '10.1.1.120';
$method= 'SSL;
$*/
$connect=explode(',',trim(file_get_contents('connect.txt')));
if(isset($connect)) {
    $connectIPString=$connect[0];
    $customer=$connect[1];
    $serial=$connect[2];
} else {
    $connectIPString="192.168.1.101";
    $customer="541B31C7";
    $serial="deadbeeffeed";
    $error=1;
};

//Quick authentication check so foreground process can react appropriately.
//Open socket.
echo $connectIPString;
$error=0;
//$certificate="MIICQTCCAaqgAwIBAgIQehwNQNoLN5tPl7LsFDNLOzANBgkqhkiG9w0BAQUFADA2MRwwGgYDVQQKDBNQZXJjaXZhbCBTY2llbnRpZmljMRYwFAYDVQQDDA1JbnRlbGx1c0Nsb3VkMB4XDTE0MDkwMTAwMDAwMFoXDTM5MDkwMTAwMDAwMFowNjEcMBoGA1UECgwTUGVyY2l2YWwgU2NpZW50aWZpYzEWMBQGA1UEAwwNSW50ZWxsdXNDbG91ZDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAsLnmk+GLiy6nYwwSV2ewVlV4gxnIiHZZ1k/OVPBwr1rd7swyU+c6vIYWMKz6Kz4+7/XoB+PSSpq9H2ktND6Dps+GzrEmLinKdGOfCr/NMmx6j/SmKd4XIuzzjEbBCpVBgNeEYxMflMdU7xNgCRIJIkNFlqmZJ5jsbPTW9OfUs+8CAwEAAaNQME4wHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMA4GA1UdDwEB/wQEAwIFoDAdBgNVHQ4EFgQUtssPj1zcg9VcP+q/nPzKJWwMVwEwDQYJKoZIhvcNAQEFBQADgYEAX6sDf3GeM8tAb1pT5ldZKGg++RL3kEI/5XJ+Lu4IJIhJiejLHMbvTUjospBCQHcTZZsHbsDmExjpWrZJn54I8KaX2SprqV4aUNbe8jbk+J+a6GokeOlFIxN7oDS6q4crAql5xycFOHASbEh5Cie9/4RPTDdT30REktG6fuA3BGI=";
$fp = fsockopen($connectIPString, 61613, $errno, $errstr, 10);
echo "$errstr ($errno)<br/>\n";
if (!$fp) {
    $error=1;
    $fname="debugger.txt";
    $nfile = fopen($fname, "w");
    if($nfile != false) { 
        fwrite($nfile,"Can not open socket to $connectIPString.");
        fclose($nfile);
    };
    echo "$errstr ($errno)<br />\n";
    echo "err<br />\n";
} else {
    //Test case.
    //$customer='541B31C7';
    //$serial= '0003AA008672';
    $passcode=base64_encode(sha1('hsDDQmUboZLw9oSARG7vMggO40CXSeJ0GLJJH6IIyh1x5Y7RulliN1gzuKqtU6b2mzXu1vUuFMWw84dborwJg8G8nxyUrQJ13vlVjD3WaDVxLLTVqVKJghidZDpmFEuqbAjWduao7zI2q4KKFB1zVHsbNLzUvLUQaFVS0Jj1vMxOQqU8fulJMB5bSKu0wjGqeb8bOz2jFS4uuZgZP4iPYZTy4ZZhLytSWn2rv8QeiYDo486Dqv7SSaJHuG32Nd3oGz8U1VW8DVYMugMJirbf5pAfJc0WxjNCQoAVF8iqBlhgyFmXOUVWNaq7AV2BYkziqpdIqJ2GZ4FlpvxMZzEwbUxvm0zTgU2efU51b6UrslpVyhJtzBN5vzoIHtRchMaTOwGpnzaQxcYD6HDsM1UiYIKRW28lCT2RiJXONTlnNhnoPAVCUpaYF4x7VM5B3o2QXZdqxieJXzw8Tclou9e0qIshtMzyIIixu96jnfLh1bRfbwGPfU42U70UHv9otNEb'.$customer.$serial,true));
    //Connect to STOMP server.
    $out = "STOMP\n";
    $out .= "accept-version:1.2\n";
    $out .= "login:{$customer}/{$serial}\n";
    $out .= "passcode:{$passcode}\n\n\0";
    $b=fwrite($fp, $out);
    //socket_write($spawn,$out);
    //Receive message with session id.
    $sessionid=substr(fread($fp, 66),30,8); //this is not a very flexible parser!
    sleep(1);
    var_dump($sessionid);
    //Send configuration data of chamber.
    $configMessage=configurationMessage($ipChamber);
//$configMessage="Year,Month,Day,Hour,Minute,Mode,Prog_Name,Prog_Step,Seq_Step,Seq_Iter,PV_1,SP_1\n0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n5,0,0,0,0,0,0\n0,0,0,0\nTEMP,RH  ,AUX ,LS1 ,LS2 ,LS3 ,LS4 \nC  ,%RH ,PPM,UML,UML,UML,UML\n0,0,0,0,0,0,0,0,0,0,0";
    $length=strlen($configMessage);
    $message="SEND\ndestination:/config\nreceipt:{$sessionid}\nsession:{$sessionid}\ncontent-type:text/plain\ncontent-length:{$length}\n\n{$configMessage}\0";
    $b=fwrite($fp,$message);
    if($b==0) {
        $error=1;
    };
    //Receive acknowledgement.
    $ack=fread($fp,30);
    //Disconnect.
    $message="DISCONNECT\nreceipt:00000000\n\n\0";
    fwrite($fp,$message);
    $ack=fread($fp,28);
    fclose($fp);
};

$fname="debugger.txt";
$nfile = fopen($fname, "w");
if($nfile != false) { 
    if($error==1) {
        fwrite($nfile,"Can not open socket.");
    } else{ 
        fwrite($nfile,"Starting up loop.");
    };
	fclose($nfile);
};

if($error!=1) {
    //Open socket.
    $fp = fsockopen($connectIPString, 61613, $errno, $errstr, 10);
    if (!$fp) {
        $fname="debugger.txt";
        $nfile = fopen($fname, "w");
        if($nfile != false) { 
            fwrite($nfile,"Can not open socket.");
            fclose($nfile);
        };
        echo "$errstr ($errno)<br />\n";
        echo "err<br />\n";
    } else {
        //Test case.
        //$customer='541B31C7';
        //$serial= '0003AA008672';
        $passcode=base64_encode(sha1('hsDDQmUboZLw9oSARG7vMggO40CXSeJ0GLJJH6IIyh1x5Y7RulliN1gzuKqtU6b2mzXu1vUuFMWw84dborwJg8G8nxyUrQJ13vlVjD3WaDVxLLTVqVKJghidZDpmFEuqbAjWduao7zI2q4KKFB1zVHsbNLzUvLUQaFVS0Jj1vMxOQqU8fulJMB5bSKu0wjGqeb8bOz2jFS4uuZgZP4iPYZTy4ZZhLytSWn2rv8QeiYDo486Dqv7SSaJHuG32Nd3oGz8U1VW8DVYMugMJirbf5pAfJc0WxjNCQoAVF8iqBlhgyFmXOUVWNaq7AV2BYkziqpdIqJ2GZ4FlpvxMZzEwbUxvm0zTgU2efU51b6UrslpVyhJtzBN5vzoIHtRchMaTOwGpnzaQxcYD6HDsM1UiYIKRW28lCT2RiJXONTlnNhnoPAVCUpaYF4x7VM5B3o2QXZdqxieJXzw8Tclou9e0qIshtMzyIIixu96jnfLh1bRfbwGPfU42U70UHv9otNEb'.$customer.$serial,true));
        //Connect to STOMP server.
        $out = "STOMP\n";
        $out .= "accept-version:1.2\n";
        $out .= "login:{$customer}/{$serial}\n";
        $out .= "passcode:{$passcode}\n\n\0";
        $b=fwrite($fp, $out);
        //socket_write($spawn,$out);
        echo "<BR>Login{$b}<BR>";
        sleep(1);
        //Receive message with session id.
        $sessionid=substr(fread($fp, 66),30,8); //this is not a very flexible parser!
        sleep(1);
        echo "{$sessionid}<BR>";
        //Send configuration data of chamber.
        $configMessage=configurationMessage($ipChamber);
    //$configMessage="Year,Month,Day,Hour,Minute,Mode,Prog_Name,Prog_Step,Seq_Step,Seq_Iter,PV_1,SP_1\n0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n5,0,0,0,0,0,0\n0,0,0,0\nTEMP,RH  ,AUX ,LS1 ,LS2 ,LS3 ,LS4 \nC  ,%RH ,PPM,UML,UML,UML,UML\n0,0,0,0,0,0,0,0,0,0,0";
        $length=strlen($configMessage);
        echo $length;
        echo "<BR>";
        $message="SEND\ndestination:/config\nreceipt:{$sessionid}\nsession:{$sessionid}\ncontent-type:text/plain\ncontent-length:{$length}\n\n{$configMessage}\0";
        echo $message;
        $b=fwrite($fp,$message);
        echo "<BR>Config:{$b}<BR>";
        //Receive acknowledgement.
        echo "<BR>";
        echo fread($fp,30);
        echo "<BR>";
        sleep(1);
        //Send chamber data.
        $data=standardData($ipChamber);
    //$data="2014,4,28,10,0,PROG,2111301,1,1,2,21.9,22,63,69.9,63,69.9,0.3,0.3,0.3,0.3,55,-5,48,-10,15000,OFF ,OFF ,OFF ,OFF ,NO  ,NO  ,NO  ,NO  ,0,0,0,1115";
        $length=strlen($data);
        $message="SEND\ndestination:/data\nreceipt:{$sessionid}\nsession:{$sessionid}\ncontent-type:text/plain\ncontent-length:{$length}\n\n{$data}\0";
        echo $message;
        $b=fwrite($fp,$message);
        if($b==0){
            $error=1;
        };
        echo "<BR>Data:{$b}<BR>";
        //Receive acknowledgement.
        echo "<BR>";
        echo fread($fp,30);
        echo "<BR>";
        //Disconnect.
        echo "D/cing, this server sucks, is laggy, and the mods support campers.<BR>";
        $message="DISCONNECT\nreceipt:00000000\n\n\0";
        fwrite($fp,$message);
        sleep(1);
        echo "<BR>";
        echo fread($fp,28);
        echo "<BR>";
        sleep(1);
        fclose($fp);
    };
};

$fname="debugger.txt";
$nfile = fopen($fname, "w");
if($nfile != false) { 
    if($error==1) {
        fwrite($nfile,"Can not open socket.");
    } else {
        fwrite($nfile,"4,bob");
    };
	fclose($nfile);
};
?>
