<?php
include 'credentialCheck.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Refresh" content="3600; url=index.php">
		<title>Diurnal</title>
		<style>
			body {
				font-family: 'Calibri',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 14px;
				color: #6F6D6D;
				margin-left:10vw;
			}
			table {
				display: table;
				border-spacing: 1em 1em;
			}
			table tr {
				background-color: #F7F7F7;
				display: table-cell;
				box-shadow: 2px 2px 2px 2px rgb(0,0,0,35%);
				border-radius: 4px;
			}
			table tr td {
				display: block;
				background-clip: content-box;
			}
			th {
				height:100%;
				width:100%;
				display: block;
				background-clip: content-box;
			}
			input {
				width:8em;
				font-family: 'ArialMT','Arial',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.textField {
				border-radius: 4px;
				border-color: #FFFFFF;
				box-shadow: 1px 1px 0px #6F6D6D;
			}
			.forceRight {
				float:right;
			}
			.hideme {
				display:none;
				visibility:hidden;
			}
			.save {
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			.tdelement {
				background-color: #FFF;
				padding:8px;
				margin: 0.125em 0.25em 0.125em 0.25em;
				border-radius: 4px;
			}
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="jquery.modal.min.js"></script>
		<link rel="stylesheet"  type="text/css" href="jquery.modal.min.css">
		<script>
//Manual sort button if you click on the 'time' th label...this block is not needed given that those labels have been force hidden by css magic, but is nice for debugging and troubleshooting.
function sortTable() {
	var table = $('#program');
	$('#time')
	    .wrapInner('<span title="sort this column"/>')
	    .each(function(){

		var th = $(this),
		    thIndex = th.index(),
		    inverse = false;

		th.click(function(){


		    table.find('input').filter(function(){

			return $(this).index() === thIndex;

		    }).sortElements(function(a, b){
			    a=a.value;
			    b=b.value;
	    console.log(a);
	    console.log(b);
			    //console.log(a>b)

			if( a==b )//$.text([a]) == $.text([b]) )
			    return 0;

			return a > b ?//$.text([a]) > $.text([b]) ?
			    inverse ? -1 : 1
			    : inverse ? 1 : -1;

		    }, function(){

			// parentNode is the element we want to move
			return this.parentNode.parentNode.parentNode; 

		    });

		    inverse = !inverse;

		});

	    });
};

//Correctly sort programming blocks to keep them in chronological order.
function postSort() {
    var table = $('#program');
    $('#time').each(function(){
    var th = $(this),
    thIndex = th.index(),
    inverse = false;

    table.find('input').filter(function(){

	return $(this).index() === thIndex;

    }).sortElements(function(a, b){
	    a=a.value;
	    b=b.value;
	    //console.log(a>b)

	if( a==b )//$.text([a]) == $.text([b]) )
	    return 0;

	return a > b ?//$.text([a]) > $.text([b]) ?
	    inverse ? -1 : 1
	    : inverse ? 1 : -1;

    }, function(){

	// parentNode is the element we want to move
	return this.parentNode.parentNode.parentNode; 

    });

    inverse = !inverse;
    });
}

			//Insert new block step.
			$( function() {
			 $('#ins').click(function () {
			     $("#program").each(function () {
				 var tds = '<tr>';
				 var num = 1;
				 var counter=0;
				 jQuery.each($('tr:last td', this), function () {
					 tds += '<td>' + $(this).html() + '</td>';
				     counter++;
				 });
				 tds += '</tr>';
				 if ($('tbody', this).length > 0) {
				     $('tbody', this).append(tds);
				 } else {
				     $(this).append(tds);
				 }
				 $('body').outerWidth($('body').outerWidth()+200);
				 console.log($('body').outerWidth()+200);
			     });
				 postSort();
				$( function() {
				 $('.del').click(function () {
					 console.log($(this).closest('tr').remove());
					 postSort();
				});
				});
			});
			});

			//Delete a block step.
			$( function() {
			 $('.del').click(function () {
				 console.log($(this).closest('tr').remove());
				 postSort();
			});
			});
		</script>
	</head>
	<body>
<?php
include 'lhs.php';
echo LHS('diurnal'); //TODO:  Grab from server URI.
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function diurnalTimes($string) {
	$times=[];
	preg_match_all("/TIME>[^<]+<\//",$string,$matches);
	for($i=0;$i<2;$i++) {
		$time=substr($matches[0][$i],5,-2);
		$second=$time%60;
		$minute=(($time-$second*60)/60)%60;
		$hour=($time-$minute*60-$second*3600)/3600;
		if(strlen($minute)==1) {
			$minute="0".$minute;
		};
		if(strlen($hour)==1) {
			$hour="0".$hour;
		};
		$time=$hour.":".$minute;
		$times[$i]=$time;
	};
	return $times;
};
function diurnalDaySPs($string) {
	$SPs=[];
	for($i=1;$i<8;$i++) {
		preg_match_all("/{$i}_Day>[^<]+<\//",$string,$matches);
		$matches=substr($matches[0][0],6,-2);
		$SPs[$i]=floatval($matches);
	};
	return $SPs;
};
function diurnalNightSPs($string) {
	$SPs=[];
	for($i=1;$i<8;$i++) {
		preg_match_all("/{$i}_Night>[^<]+<\//",$string,$matches);
		$matches=substr($matches[0][0],8,-2);
		$SPs[$i]=floatval($matches);
	};
	return $SPs;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$time,$SP,$dayFlagFighterOfTheNightFlag) {
	$str.="<tr>";
	if($dayFlagFighterOfTheNightFlag) {
		$str.="<td><div class='tdelement'>DAY</div></td>";
	} else {
		$str.="<td><div class='tdelement'>NIGHT</div></td>";
	};
	$str.="<td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$k]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField' step='0.1'></div></td>";
		};
	};
	$str.="</tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

//IF USER DATA ENTERED, SEND IT OFF TO SAVE A PROGRAM.
$ngip="https://127.0.0.2";
if (!empty($_POST)) {
    //Grab user selected values.
    $posted = &$_POST;
    $ch=curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    if($posted['save']=='Run Diurnal') {
	echo "Running Diurnal Mode.";
        $url=$ngip."/ramping.xml?Cmd=run&Item=nr_diurnal";
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_exec($ch);
    } else {
        $times=$posted['time'];
        $times=array_map('clock2Minutes',$times);
        $inputs=[];
        $events=[];
        for($i=1;$i<8;$i++) {
            if(!empty($posted["SO$i"])) {
                $so[$i]=$posted["SO$i"];
                $inputs[]=$i;
            };
        };
        //Day step.
        $url=$ngip."/read_data.xml?Cmd=write";
        $time=$times[0];
        $url.="&CM_DIURNAL_DAY_START_TIME=$time";
        foreach($inputs as $k) {
            $in=$so[$k][0]*1000;
            $url.="&CM_SP_{$k}_Day=".$in;
        };
        $time=$times[1];
        $url.="&CM_DIURNAL_DAY_END_TIME=$time";
        foreach($inputs as $k) {
            $in=$so[$k][1]*1000;
            $url.="&CM_SP_{$k}_Night=".$in;
        };
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_exec($ch);
    };
    curl_close($ch);
};


//GRAB CONTROLLER DATA TO CORRECTLY SET UP PROGRAMMER.
$inputNames=$ngip."/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$highRangeTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_SP_High_1&Tag=CLC_SP_High_2&Tag=CLC_SP_High_3&Tag=CLC_SP_High_4&Tag=CLC_SP_High_5&Tag=CLC_SP_High_6&Tag=CLC_SP_High_7";
$lowRangeTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_SP_Low_1&Tag=CLC_SP_Low_2&Tag=CLC_SP_Low_3&Tag=CLC_SP_Low_4&Tag=CLC_SP_Low_5&Tag=CLC_SP_Low_6&Tag=CLC_SP_Low_7";
$diurnalTags=$ngip."/read_data.xml?Cmd=read&Tag=CM_DIURNAL_DAY_START_TIME&Tag=CM_DIURNAL_DAY_END_TIME&Tag=CM_SP_1_Day&Tag=CM_SP_1_Night&Tag=CM_SP_2_Day&Tag=CM_SP_2_Night&Tag=CM_SP_3_Day&Tag=CM_SP_3_Night&Tag=CM_SP_4_Day&Tag=CM_SP_4_Night&Tag=CM_SP_5_Day&Tag=CM_SP_5_Night&Tag=CM_SP_6_Day&Tag=CM_SP_6_Night&Tag=CM_SP_7_Day&Tag=CM_SP_7_Night";
$manualCheck=$ngip."/read_data.xml?Cmd=read&Tag=CM_RAMPING_MODE";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $manualCheck);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
$manualCheck=preg_match('/Manual/',curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputNames);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highRangeTags);
$highRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowRangeTags);
$lowRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputTags);
$inputTags=inputCheck(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $diurnalTags);
$diurnalTags=curl_exec($ch);
$diurnalTimes=diurnalTimes($diurnalTags);
$diurnalDaySPs=diurnalDaySPs($diurnalTags);
$diurnalNightSPs=diurnalNightSPs($diurnalTags);


//START WRITING THE ACTUAL PAGE GIVEN CONTROLLER DATA--with exception of outputs to make writing easier.
$str="<form action='diurnal.php' method='post' enctype='multipart/form-data'>";
//IMPORT CURRENT DIURNAL.
$str.="<table id='program'><tbody><tr class='hideme'>";
$str.="<th id='time'>Time</th>";
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		$str.="<th>".$inputNames[$i]."</th>";
	};
};
$str.="<th>Edit</th></tr>";
//O.K.,  let's write this bad boy.
//Day Step
$str=stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$diurnalTimes[0],$diurnalDaySPs,1);
//Night Step
$str=stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$diurnalTimes[1],$diurnalNightSPs,0);
//Finish this nonsense up.
$str.="</tbody></table><BR>";
if($manualCheck) {
    $str.="<input type='submit' name='save' value='Save' class='save'>";
} else {
    $str.="<BR>(Please go to settings to change back to manual mode to save)<BR>";
};
$str.="<input type='submit' name='save' value='Run Diurnal' class='save'>";
$str.="</form>";
//Generate Alarms modal.
	$str.="<div id='alarmsModal' class='modal'>";
	$str.="<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' aria-hidden='true' role='img' width='10em' height='10em' preserveAspectRatio='xMidYMid meet' viewBox='0 0 896 1024'><path d='M842 712l-20-25l-19.5-26l-19-29.5l-15-30l-11.5-33l-4-31.5V328q0-67-24-127.5t-64.5-104T567 27T446 1q-84 0-154.5 44T181 164t-40 164v209q0 18-5 36.5t-18 40t-20 32T72 681t-22 28l-18 25.5l-14 22l-10.5 22L5 798l5 21q17 33 83 33h183q0 71 50 121t121 50t121-50t50-121h187q66 0 81-33q4-7 4.5-14.5t0-13.5t-4.5-14.5t-7-14.5t-10.5-16t-12.5-16t-14-18zM447 956q-21 0-40-8.5t-33-22t-22.5-33T343 852h208q0 43-30.5 73.5T447 956zm358-172H81q6-10 24-34q1-2 20-27t25-33t21-32.5t20.5-39.5t11.5-38t6-43V328q0-108 68.5-183.5T446 69q29 0 56 7t50.5 19.5t44 30.5t37 40.5t28 47.5t17.5 54t6 60v209q0 31 9 62.5t27.5 61.5t32 48.5T789 755l4.5 6l4.5 5.5l5 6l4.5 5.5l4.5 6h-7z' fill='#3f796b'/></svg><BR><BR>";
	$str.="<div id='alarmsIndication'>";
	$str.="</div>";
	$str.="</div>";
//End Alarms modal.
echo $str;
echo "<BR>";
curl_close($ch);
?>
<script>
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	};
	});
setInterval(function(){
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	} else {
		$.modal.close();
	};
	});
},60000);
</script>
	</body>
</html>

