<?php
include 'credentialCheck.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<title>Sequence Maker</title>
		<style>
			body {
				font-family: 'Calibri',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 14px;
				color: #6F6D6D;
				margin-left:10vw;
			}
			table {
				display: table;
				border-spacing: 1em 1em;
				overflow:auto;
			}
			table tr {
				background-color: #F7F7F7;
				display: table-cell;
				box-shadow: 2px 2px 2px 2px rgb(0,0,0,35%);
				border-radius: 4px;
				overflow:auto;
			}
			table tr td {
				display: block;
				background-clip: content-box;
				overflow:auto;
			}
			th {
				height:100%;
				width:100%;
				display: block;
				background-clip: content-box;
			}
			input {
				width:8em;
				font-family: 'ArialMT','Arial',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.textField {
				border-radius: 4px;
				border-color: #FFFFFF;
				box-shadow: 1px 1px 0px #6F6D6D;
			}
			.forceRight {
				float:right;
			}
			.hideme {
				display:none;
				visibility:hidden;
			}
			.save {
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			.tdelement {
				background-color: #FFF;
				padding:8px;
				margin: 0.125em 0.25em 0.125em 0.25em;
				border-radius: 4px;
			}
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="jquery.modal.min.js"></script>
		<link rel="stylesheet"  type="text/css" href="jquery.modal.min.css">
		<script>
			//Insert new block step.
			$( function() {
			 $('#ins').click(function () {
			     $("#program").each(function () {
				 var tds = '<tr>';
				 var num = 1;
				 var counter=0;
				 jQuery.each($('tr:last td', this), function () {
					 tds += '<td>' + $(this).html() + '</td>';
				     counter++;
				 });
				 tds += '</tr>';
				 if ($('tbody', this).length > 0) {
				     $('tbody', this).append(tds);
				 } else {
				     $(this).append(tds);
				 }
				 $('body').outerWidth($('body').outerWidth()+200);
				 console.log($('body').outerWidth()+200);
			     });
				 //postSort();
				$( function() {
				 $('.del').click(function () {
					 console.log($(this).closest('tr').remove());
					 //postSort();
				});
				});
			});
			});

			//Delete a block step.
			$( function() {
			 $('.del').click(function () {
				 console.log($(this).closest('tr').remove());
				 //postSort();
			});
			});
		</script>
	</head>
	<body>
<?php
include 'lhs.php';
echo LHS('sequence'); //TODO:  Grab from server URI.
//Mainly a lot of parsing functions for the Intellus XML.
function sequenceNames($string) {
	preg_match_all("/Name>[^<]+<\/Name/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	if(!isset($names)) {
		$names[0]="";
	};
	return $names;
}
function sequenceIterations($string) {
	preg_match_all("/Iterations>[^<]+<\/Iterations/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$iterations[$i]=substr($matches[$i],11,-12);
	};
	if(!isset($iterations)) {
		$iterations[0]=1;
	};
	return $iterations;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepWriter($str,$programNames,$program,$iteration) {
	if(empty($programNames)) {
		$str.="<tr><td><div class='tdelement'>Please make some programs first.</div></td><td><div class='tdelement'>1-555-COME-ON-NOW</div></td><td><div class='tdelement'>Work with me here.</div></td></tr>";
	} else {
		$str.="<tr><td><div class='tdelement'>Program<select name='name[]' class='forceRight'>";
		foreach($programNames as $programName) {
			if(trim($program)===trim($programName)) {
				$str.="<option value='$programName' selected>$programName</option>";
			} else {
				$str.="<option value='$programName'>$programName</option>";
			};
		};
		$str.="</select></div></td>";
		$str.="<td><div class='tdelement'>Iterations<input name='iterations[]' type='number' value='".$iteration."' min='1' max='500' class='forceRight textField'></div></td>";
		$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	};
	return $str;
};
//END FUNCTION DECLARATIONS

//GRAB CONTROLLER DATA TO CORRECTLY SET UP PROGRAMMER.
$ngip="https://127.0.0.2";
$programNames=$ngip."/ramping.xml?Cmd=read&Item=file_list";
$sequence=$ngip."/sequence.xml?Cmd=read&Item=sequence";
$manualCheck=$ngip."/read_data.xml?Cmd=read&Tag=CM_RAMPING_MODE";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $manualCheck);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
$manualCheck=preg_match('/Manual/',curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $programNames);
$programNames=programNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $sequence);
$sequenceNames=sequenceNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $sequence);
$sequenceIterations=sequenceIterations(curl_exec($ch));

//IF USER DATA ENTERED, SEND IT OFF TO SAVE THE SEQUENCE.
if (!empty($_POST)) {
    //Grab user selected values.
    $posted = &$_POST;
    if(!empty($posted["name"])) {
	    $programs=$posted['name'];
    } else {
	    $programs="TEMP";
    };
    if($posted['save']=='Run Sequence') {
	echo "Running Sequence.";
        $url=$ngip."/sequence.xml?Cmd=run&Item=sequence&Step=1&Iteration=1";
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_exec($ch);
    } else {
        $iterations=$posted['iterations'];
        //Delete previous sequence to replace it.
            $url=$ngip."/sequence.xml?Cmd=delete&Item=sequence";
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_exec($ch);
        for($i=0;$i<count($programs);$i++) {
            //Send steps one by one...
            $url=$ngip."/sequence.xml?Cmd=add&Item=step&File=".rawurlencode($programs[$i])."&Iterations=".$iterations[$i];
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_exec($ch);
        };
    };
};

//START WRITING THE ACTUAL PAGE GIVEN CONTROLLER DATA--with exception of outputs to make writing easier.
$str="<form action='sequence.php' method='post' enctype='multipart/form-data'>";
$str.="<table id='program'><tbody><tr class='hideme'>";
$str.="<th id='program'>Program</th>";
$str.="<th>Iterations</th>";
$str.="<th>Edit</th></tr>";
if($sequenceNames) {
	//Import current sequence to edit it.
	for($i=0;$i<count($sequenceNames);$i++) {
		$str=stepWriter($str,$programNames,$sequenceNames[$i],$sequenceIterations[$i]);
	};
} else {
	//If no imported program, set a default.
	$str=stepWriter($str,$programNames,"","1");
};
//Finish this nonsense up.
$str.="</tbody></table><BR>";
$str.="<a href='#' id='ins' class='save'>Add Step</a><BR>";
if($manualCheck) {
    $str.="<input type='submit' name='save' value='Save' class='save'>";
} else {
    $str.="<BR>(Please go to settings to change back to manual mode to save)<BR>";
};
$str.="<input type='submit' name='save' value='Run Sequence' class='save'>";
$str.="</form>";
//Generate Alarms modal.
	$str.="<div id='alarmsModal' class='modal'>";
	$str.="<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' aria-hidden='true' role='img' width='10em' height='10em' preserveAspectRatio='xMidYMid meet' viewBox='0 0 896 1024'><path d='M842 712l-20-25l-19.5-26l-19-29.5l-15-30l-11.5-33l-4-31.5V328q0-67-24-127.5t-64.5-104T567 27T446 1q-84 0-154.5 44T181 164t-40 164v209q0 18-5 36.5t-18 40t-20 32T72 681t-22 28l-18 25.5l-14 22l-10.5 22L5 798l5 21q17 33 83 33h183q0 71 50 121t121 50t121-50t50-121h187q66 0 81-33q4-7 4.5-14.5t0-13.5t-4.5-14.5t-7-14.5t-10.5-16t-12.5-16t-14-18zM447 956q-21 0-40-8.5t-33-22t-22.5-33T343 852h208q0 43-30.5 73.5T447 956zm358-172H81q6-10 24-34q1-2 20-27t25-33t21-32.5t20.5-39.5t11.5-38t6-43V328q0-108 68.5-183.5T446 69q29 0 56 7t50.5 19.5t44 30.5t37 40.5t28 47.5t17.5 54t6 60v209q0 31 9 62.5t27.5 61.5t32 48.5T789 755l4.5 6l4.5 5.5l5 6l4.5 5.5l4.5 6h-7z' fill='#3f796b'/></svg><BR><BR>";
	$str.="<div id='alarmsIndication'>";
	$str.="</div>";
	$str.="</div>";
//End Alarms modal.
echo $str;
echo "<BR>";
curl_close($ch);
?>
<script>
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	};
	});
setInterval(function(){
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	} else {
		$.modal.close();
	};
	});
},60000);
</script>
	</body>
</html>

